/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.ftb.data.UserManager;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.util.SwingUtils;

public class ProfileEditorDialog
extends JDialog {
    private JLabel usernameLbl;
    private JTextField username;
    private JLabel passwordLbl;
    private JPasswordField password;
    private JLabel nameLbl;
    private JTextField name;
    private JCheckBox savePassword;
    private JCheckBox saveMojangData;
    private JButton update;
    private JButton remove;

    public ProfileEditorDialog(LaunchFrame instance, final String editingName, boolean modal) {
        super((Frame)instance, modal);
        this.setupGui();
        this.getRootPane().setDefaultButton(this.update);
        this.username.setText(UserManager.getUsername(editingName));
        this.name.setText(editingName);
        if (UserManager.getPassword(editingName).isEmpty()) {
            this.password.setEnabled(false);
            this.savePassword.setSelected(false);
        } else {
            this.password.setText(UserManager.getPassword(editingName));
            this.savePassword.setSelected(true);
        }
        this.saveMojangData.setSelected(UserManager.getSaveMojangData(editingName));
        this.username.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                ProfileEditorDialog.this.name.setText(ProfileEditorDialog.this.username.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                ProfileEditorDialog.this.name.setText(ProfileEditorDialog.this.username.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.savePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProfileEditorDialog.this.password.setEnabled(ProfileEditorDialog.this.savePassword.isSelected());
            }
        });
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (editingName.equals(ProfileEditorDialog.this.name.getText()) || !UserManager.getUsernames().contains(ProfileEditorDialog.this.username.getText()) && !UserManager.getNames().contains(ProfileEditorDialog.this.name.getText())) {
                    if (ProfileEditorDialog.this.savePassword.isSelected()) {
                        if (ProfileEditorDialog.this.password.getPassword().length > 1) {
                            UserManager.updateUser(editingName, ProfileEditorDialog.this.username.getText(), new String(ProfileEditorDialog.this.password.getPassword()), ProfileEditorDialog.this.name.getText());
                        }
                    } else {
                        UserManager.updateUser(editingName, ProfileEditorDialog.this.username.getText(), "", ProfileEditorDialog.this.name.getText());
                    }
                    UserManager.setSaveMojangData(ProfileEditorDialog.this.username.getText(), ProfileEditorDialog.this.saveMojangData.isSelected());
                    LaunchFrame.writeUsers(ProfileEditorDialog.this.name.getText());
                    ProfileEditorDialog.this.setVisible(false);
                }
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserManager.removeUser(editingName);
                LaunchFrame.writeUsers(null);
                ProfileEditorDialog.this.setVisible(false);
            }
        });
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("PROFILEDITOR_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.usernameLbl = new JLabel(I18N.getLocaleString("PROFILEADDER_USERNAME"));
        this.username = new JTextField(16);
        this.passwordLbl = new JLabel(I18N.getLocaleString("PROFILEADDER_PASSWORD"));
        this.password = new JPasswordField(16);
        this.nameLbl = new JLabel(I18N.getLocaleString("PROFILEADDER_NAME"));
        this.name = new JTextField(16);
        this.savePassword = new JCheckBox(I18N.getLocaleString("PROFILEADDER_SAVEPASSWORD"));
        this.saveMojangData = new JCheckBox(I18N.getLocaleString("PROFILEADDER_SAVEMOJANGDATA"));
        this.update = new JButton(I18N.getLocaleString("PROFILEADDER_UPDATE"));
        this.remove = new JButton(I18N.getLocaleString("MAIN_REMOVE"));
        this.usernameLbl.setLabelFor(this.username);
        this.passwordLbl.setLabelFor(this.password);
        this.nameLbl.setLabelFor(this.name);
        panel.add(this.usernameLbl);
        panel.add(this.username);
        panel.add(this.passwordLbl);
        panel.add(this.password);
        panel.add(this.nameLbl);
        panel.add(this.name);
        panel.add(this.savePassword);
        panel.add(this.saveMojangData);
        panel.add(this.update);
        panel.add(this.remove);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.usernameLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.passwordLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.nameLbl, hSpring, "West", (Component)panel);
        Spring columnWidth = SwingUtils.springMax(Spring.width(this.usernameLbl), Spring.width(this.passwordLbl), Spring.width(this.nameLbl));
        hSpring = SwingUtils.springSum(hSpring, columnWidth, Spring.constant(10));
        layout.putConstraint("West", (Component)this.username, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.password, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.name, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.savePassword, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.saveMojangData, hSpring, "West", (Component)panel);
        columnWidth = SwingUtils.springMax(Spring.width(this.username), Spring.width(this.password), Spring.width(this.name), Spring.width(this.savePassword), Spring.width(this.saveMojangData));
        hSpring = SwingUtils.springSum(hSpring, columnWidth, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.update, -5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)this.remove, 5, "HorizontalCenter", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("Baseline", (Component)this.usernameLbl, 0, "Baseline", (Component)this.username);
        layout.putConstraint("North", (Component)this.username, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.max(Spring.height(this.usernameLbl), Spring.height(this.username));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("Baseline", (Component)this.passwordLbl, 0, "Baseline", (Component)this.password);
        layout.putConstraint("North", (Component)this.password, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.passwordLbl), Spring.height(this.password));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("Baseline", (Component)this.nameLbl, 0, "Baseline", (Component)this.name);
        layout.putConstraint("North", (Component)this.name, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.nameLbl), Spring.height(this.name));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("North", (Component)this.savePassword, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.savePassword), Spring.constant(10));
        layout.putConstraint("North", (Component)this.saveMojangData, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.saveMojangData), Spring.constant(10));
        layout.putConstraint("North", (Component)this.update, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.remove, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.update), Spring.height(this.remove));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

